/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm2210;

import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class Box1XGraphic {
    private GenModel jdm2210Model;
    private boolean isLogging = false;
    private GenModel systemModel;
    private GenModel interface2210Model;
    private JdmBrowser jdm2210Browser;
    private Vector modelList;
    private Vector remoteStatusList;
    private Vector proxyStatusList;
    private Vector pcmcia_Info = new Vector();
    private Vector interfaceInfo;
    private int boxType;
    private Point boxPoint = new Point(20, 20);
    private static final String PropertiesFile = "properties/jdm2210.txt";
    private static final String layoutKey = "box.layout.scheme";
    private static final String fractKey = "box.layout.fractions";
    static final String HelpRef_Dir = "ibm.nways.jdm2210";
    static final String HelpRef_2210html = "ibm.nways.jdm2210.BoxGraphic.html";

    protected Box1XGraphic(JdmBrowser jdmBrowser, int n) {
        if (jdmBrowser.getIsApplication()) {
            this.isLogging = Log.getLog().getLoggingState();
        }
        this.modelList = new Vector();
        this.remoteStatusList = new Vector();
        this.proxyStatusList = new Vector();
        this.jdm2210Browser = jdmBrowser;
        this.boxType = n;
    }

    protected GraphicPanel getGraphicPanel() {
        Properties properties;
        Serializable serializable;
        GraphicContainer graphicContainer = new GraphicContainer();
        try {
            serializable = new URL(this.jdm2210Browser.getDocumentBase(), PropertiesFile);
            if (this.isLogging) {
                System.out.println("DocumentBase = " + this.jdm2210Browser.getDocumentBase());
            }
            properties = new Properties();
            properties.load(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            System.out.println("Error getting Jdm2210 Properties: " + exception.getMessage());
            properties = null;
            exception.printStackTrace();
        }
        JdmLayout jdmLayout = (JdmLayout)this.jdm2210Browser.getLayout();
        if (properties != null) {
            serializable = new Integer((String)((Hashtable)properties).get(layoutKey));
            if (this.isLogging) {
                System.out.println("The layout scheme property = " + serializable);
            }
            int n = (Integer)serializable;
            jdmLayout.setScheme(n);
            String string = (String)((Hashtable)properties).get(fractKey);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            float[] fArray = new float[stringTokenizer.countTokens()];
            boolean bl = true;
            int n2 = 0;
            while (n2 < fArray.length && stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    fArray[n2] = Float.valueOf(string2).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Bad layout.fractions parm(" + numberFormatException.getMessage() + ")");
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                jdmLayout.setFracts(fArray);
            }
        }
        this.getBoxInfo();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.jdm2210.Resources");
        GraphicImage graphicImage = new GraphicImage(this.jdm2210Browser.imageFrom(this, "box1X.gif"), this.boxPoint, 3, new GraphicActionNavigate(this.jdm2210Browser, new NavigationDestination("ibm.nways.mib2.eui.SystemPanel", this.systemModel), null), null);
        graphicContainer.add(graphicImage);
        serializable = new GraphicHelp(this.jdm2210Browser, new Point(0, 0), new HelpRef(HelpRef_Dir, HelpRef_2210html));
        graphicContainer.add((GraphicComponent)serializable);
        graphicImage = this.addInterface(graphicContainer, "wanPort.gif", new Point(this.boxPoint.x + 200, this.boxPoint.y + 43), 1);
        graphicImage.setFlyOver(new GraphicFlyOver("WAN Adapter"));
        graphicImage = this.addInterface(graphicContainer, "Enet.gif", new Point(this.boxPoint.x + 252, this.boxPoint.y + 30), 0);
        graphicImage.setFlyOver(new GraphicFlyOver("Ethernet Adapter"));
        graphicImage = this.addInterface(graphicContainer, "isdn.gif", new Point(this.boxPoint.x + 300, this.boxPoint.y + 30), 2);
        graphicImage.setFlyOver(new GraphicFlyOver("ISDN Adapter"));
        GraphicPanel graphicPanel = new GraphicPanel(this.jdm2210Browser, graphicContainer);
        return graphicPanel;
    }

    private GraphicImage addInterface(GraphicContainer graphicContainer, String string, Point point, int n) {
        GraphicImage graphicImage = new GraphicImage(this.jdm2210Browser.imageFrom(this, string), point, 0, null, null);
        this.attachStatusAndAction(this.interface2210Model, graphicImage, n);
        graphicContainer.add(graphicImage);
        return graphicImage;
    }

    private void getBoxInfo() {
        if (this.systemModel == null) {
            try {
                this.systemModel = (GenModel)this.jdm2210Model.getComponent("System");
                if (this.isLogging) {
                    System.out.println("Got system2 model");
                }
            }
            catch (Exception exception) {
                System.out.println("Exception getting system2 model.");
            }
        }
        if (this.interface2210Model == null) {
            try {
                this.interface2210Model = (GenModel)this.jdm2210Model.getComponent("Interface");
                if (this.isLogging) {
                    System.out.println("Got interface model");
                    return;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception getting Graphic Interface Model");
                return;
            }
        }
    }

    protected void setJdm2210Model(GenModel genModel) {
        this.jdm2210Model = genModel;
    }

    protected void setSystemModel(GenModel genModel) {
        this.systemModel = genModel;
    }

    void attachStatusAndAction(GenModel genModel, GraphicImage graphicImage, int n) {
        if (this.interfaceInfo == null) {
            try {
                this.interfaceInfo = genModel.getRestOfInfo("_Empty", "default", null, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            NavigationContext navigationContext = new NavigationContext();
            ModelInfo modelInfo = (ModelInfo)this.interfaceInfo.elementAt(n);
            NavInitialRow.setInitialRow(navigationContext, modelInfo);
            navigationContext.setParent(this.jdm2210Browser.getNavigationTree().getNavContext());
            RemoteStatus remoteStatus = genModel.getStatusRefForRow(modelInfo);
            StatusProxy statusProxy = new StatusProxy(remoteStatus);
            GraphicActionNavigate graphicActionNavigate = new GraphicActionNavigate(this.jdm2210Browser, new NavigationDestination("ibm.nways.mib2.eui.Mib2InterfacesPanel", genModel), navigationContext);
            graphicImage.setStatus(statusProxy);
            graphicImage.setAction(graphicActionNavigate);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

